/*
 * Decompiled with CFR 0.152.
 */
package de.dustplanet.passwordprotect.listeners;

import de.dustplanet.passwordprotect.PasswordProtect;
import de.dustplanet.passwordprotect.jail.JailHelper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetEvent;

@SuppressFBWarnings(value={"IMC_IMMATURE_CLASS_NO_TOSTRING"})
public class PasswordProtectEntityListener
implements Listener {
    private static final int MAX_FOOD_LEVEL = 20;
    private final PasswordProtect plugin;
    private final JailHelper jailHelper;

    public PasswordProtectEntityListener(PasswordProtect instance, JailHelper jailHelper) {
        this.plugin = instance;
        this.jailHelper = jailHelper;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityTarget(EntityTargetEvent event) {
        if (!this.plugin.getConfig().getBoolean("prevent.triggering", true)) {
            return;
        }
        Entity target = event.getTarget();
        if (target == null) {
            return;
        }
        if (target.getType() == EntityType.PLAYER) {
            UUID playerUUID = ((Player)target).getUniqueId();
            if (this.jailHelper.getJailedPlayers().containsKey(playerUUID)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (!this.plugin.getConfig().getBoolean("prevent.attacks", true)) {
            return;
        }
        Entity damager = event.getDamager();
        if (damager.getType() == EntityType.PLAYER) {
            UUID playerUUID = ((Player)damager).getUniqueId();
            if (this.jailHelper.getJailedPlayers().containsKey(playerUUID)) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityDamage(EntityDamageEvent event) {
        if (!this.plugin.getConfig().getBoolean("prevent.damage", true)) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity.getType() == EntityType.PLAYER) {
            UUID playerUUID = ((Player)entity).getUniqueId();
            Player player = (Player)entity;
            if (this.jailHelper.getJailedPlayers().containsKey(playerUUID)) {
                player.setFoodLevel(20);
                player.setFireTicks(0);
                player.setRemainingAir(player.getMaximumAir());
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onEntityDeath(EntityDeathEvent event) {
        if (!this.plugin.getConfig().getBoolean("prevent.deathDrops", true)) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (entity.getType() == EntityType.PLAYER) {
            UUID playerUUID = ((Player)entity).getUniqueId();
            if (this.jailHelper.getJailedPlayers().containsKey(playerUUID)) {
                event.setDroppedExp(0);
                event.getDrops().clear();
            }
        }
    }
}

